package doABC.Cpool;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import doABC.CpoolInfo;
import FlashReader.SWF;
import FlashReader.SwfTools;

public class NsSetInfo extends SwfTools{
	
	private int id;
	
	private CpoolInfo cpool;

	private int start;
	private int end;
	//struktury
	private int count=-1;
	private ArrayList<Integer> ns = new ArrayList<Integer>();
	
	
	public  NsSetInfo(CpoolInfo cpool,ArrayList<Integer> ns, int id){
		super();
		this.cpool = cpool;
		this.ns=ns;
		count=ns.size();
		this.id=id;
	}
	
	public int getId() {
		return id;
	}

	public  NsSetInfo(ByteBuffer bbuf, CpoolInfo cpool, int id){
		super();
		this.cpool = cpool;
		ns_set_info(bbuf);
		this.id =id;
	}
	
	
	private void ns_set_info(ByteBuffer bbuf){
		start = bbuf.position();
		count = unsigned30int(bbuf);
		for (int i2 =0; i2<count;i2++)
			ns.add(unsigned30int(bbuf));

		end = bbuf.position()-1;
	}

	public int getStart() {
		return start;
	}


	public int getEnd() {
		return end;
	}


	public int getCount() {
		return count;
	}


	public ArrayList<Integer> getNs() {
		return ns;
	}
	
	public ArrayList<String> getNs_string() {
		 ArrayList<String> result = new  ArrayList<String>();
		 for (int i =0 ; i< ns.size();i++)
			 result.add(cpool.getStrings().get(ns.get(i)).getUtf8_string());
		return result;
	}
	
	
	public String String(){
		String wynik ="";
		wynik+="\n---#--- ns_set_info "+SWF.msgs.getString("Position")+": " + start + "\n\n";
		
		wynik+= "count: " + count+"\n";
			
		wynik+= "ns: " + getNs_string()+"\n";
			
		wynik+="\n---!!--- "+SWF.msgs.getString("Position")+":  "+end;
		
		return wynik;
		
		
	}
	
	public String toString(){
		String wynik ="";
		wynik+=getNs_string();
		return wynik;
	}
	
	
	public ArrayList<Byte> toByteCode(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		
		if (  count!=-1){
			for (byte b : getUI32(count))
				result.add(b);
			
		}
		
		if (  ns.size()>0){
			for (int i=0;i<ns.size();i++){
				for (byte b : getUI32(ns.get(i)))
					result.add(b);
			}	
		}
		
		return result;
	}
	
	
}
